package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class MksysdirFsEvent extends AbstractFsEvent {
    @BenderPart(name = "type", strictName = true)
    public final String dirType;

    public MksysdirFsEvent(EventMetadata metadata, String dirType) {
        super(metadata);
        this.dirType = dirType;
    }

    public static MksysdirFsEvent parse(TskvEventLogLine tskv) {
        return new MksysdirFsEvent(tskv.getMetadata(), tskv.getString("type"));
    }

    @Override
    public EventType getEventType() {
        return EventType.FS_MKSYSDIR;
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list();
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list(dirType);
    }
}
