package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Dmitriy Amelin (lemeh)
 * Used for parsing type and subtype from tskv
 */
@Bendable
public class StoreTypeSubtype extends DefaultObject {
    public static final StoreTypeSubtype NONE = new StoreTypeSubtype(Option.empty(), Option.empty());

    public static final String SOCIAL_COPY_TYPE = "social_copy";

    public static final Pattern2 PROVIDER_PATTERN = Pattern2.compile("^(.+?)_disk$");

    @BenderPart(name = "store_type", strictName = true)
    public final Option<String> type;

    @BenderPart(name = "store_subtype", strictName = true)
    public final Option<String> subtype;

    public StoreTypeSubtype(String type, String subtype) {
        this(Option.of(type), Option.of(subtype));
    }

    public StoreTypeSubtype(Option<String> type, Option<String> subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    public String getType() {
        return type.get();
    }

    public String getSubtype() {
        return subtype.get();
    }

    public boolean isSocialCopy() {
        return type.isSome(SOCIAL_COPY_TYPE);
    }

    public Option<String> extractProviderId() {
        if (!isSocialCopy() || !subtype.isPresent()) {
            return Option.empty();
        }

        return PROVIDER_PATTERN.findFirstGroup(subtype.get());
    }

    @Override
    public String toString() {
        if (!type.isPresent() && !subtype.isPresent()) {
            return getClass().getSimpleName() + "[none]";
        } else {
            return getClass().getSimpleName() +
                    "[type/subtype=" + type.getOrElse("") + "/" + subtype.getOrElse("") + "]";
        }
    }

    public boolean matches(StoreTypeSubtype typeSubtype) {
        return matches(this.type, typeSubtype.type) && matches(subtype, typeSubtype.subtype);
    }

    private boolean matches(Option<String> regexO, Option<String> valueO) {
        return (!valueO.isPresent() && !regexO.isPresent())
                || valueO.isMatch(v -> regexO.isMatch(v::matches));
    }
}
