package ru.yandex.chemodan.eventlog.events.fs;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class StoreTypeSubtypeTest {
    @Test
    public void testExtractProviderIdForSocialCopyVkontakte() {
        Assert.equals(Option.of("vkontakte"),
                new StoreTypeSubtype("social_copy", "vkontakte_disk").extractProviderId());
    }

    @Test
    public void testExtractProviderIdForNotSocialCopy() {
        Assert.none(new StoreTypeSubtype("not_social_copy", "vkontakte_disk").extractProviderId());
    }

    @Test
    public void testExtractProviderIdForSocialCopyForNotDisk() {
        Assert.none(new StoreTypeSubtype("not_social_copy", "vkontakte_disk_not").extractProviderId());
    }

    @Test
    public void testExtractProviderIdForNone() {
        Assert.none(StoreTypeSubtype.NONE.extractProviderId());
    }

    @Test
    public void testMatchSelf() {
        StoreTypeSubtype matcher = new StoreTypeSubtype("social_copy", "instagram_disk");
        StoreTypeSubtype typeSubtype = new StoreTypeSubtype("social_copy", "instagram_disk");
        Assert.isTrue(matcher.matches(typeSubtype));
    }

    @Test
    public void testMatchRegex() {
        StoreTypeSubtype matcher = new StoreTypeSubtype("social_copy", "[a-z]+_disk");
        StoreTypeSubtype matchee = new StoreTypeSubtype("social_copy", "instagram_disk");
        Assert.isTrue(matcher.matches(matchee));
    }

    @Test
    public void testMatchNone() {
        Assert.isTrue(StoreTypeSubtype.NONE.matches(StoreTypeSubtype.NONE));
    }
}
