package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.chemodan.eventlog.events.CompoundResourceType;

/**
 * @author Dmitriy Amelin (lemeh)
 * @see <a href="https://st.yandex-team.ru/CHEMODAN-27484">CHEMODAN-27484</a>
 */
public enum TemporaryFsEventGroup {
    IMAGE, VIDEO, FILE, DIRECTORY, ALBUM;

    public static TemporaryFsEventGroup byCompoundType(CompoundResourceType compoundType) {
        switch(compoundType.type) {
            case DIRECTORY:
                return DIRECTORY;

            case ALBUM:
                return ALBUM;

            default:
                if (!compoundType.mediaType.isPresent()) {
                    return FILE;
                }

                switch (compoundType.mediaType.get().getStandardType()) {
                    case IMAGE:
                        return IMAGE;
                    case VIDEO:
                        return VIDEO;
                    default:
                        return FILE;
                }
        }
    }
}
