package ru.yandex.chemodan.eventlog.events.fs;

import org.junit.Test;

import ru.yandex.chemodan.eventlog.events.CompoundResourceType;
import ru.yandex.chemodan.eventlog.events.StandardMediaType;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TemporaryFsEventGroupTest {
    @Test
    public void testDirectory() {
        Assert.equals(
                TemporaryFsEventGroup.DIRECTORY,
                TemporaryFsEventGroup.byCompoundType(CompoundResourceType.directory())
        );
    }

    @Test
    public void testFile() {
        Assert.equals(
                TemporaryFsEventGroup.FILE,
                TemporaryFsEventGroup.byCompoundType(CompoundResourceType.file(StandardMediaType.DATA.value()))
        );
    }

    @Test
    public void testImage() {
        Assert.equals(
                TemporaryFsEventGroup.IMAGE,
                TemporaryFsEventGroup.byCompoundType(CompoundResourceType.file(StandardMediaType.IMAGE.value()))
        );
    }

    @Test
    public void testVideo() {
        Assert.equals(
                TemporaryFsEventGroup.VIDEO,
                TemporaryFsEventGroup.byCompoundType(CompoundResourceType.file(StandardMediaType.VIDEO.value()))
        );
    }
}
