package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class TrashDropAllFsEvent extends AbstractFsEvent {
    @BenderPart(name = "owner_uid", strictName = true)
    public final MpfsUid owner;

    public TrashDropAllFsEvent(EventMetadata metadata, MpfsUid owner) {
        super(metadata);
        this.owner = owner;
    }

    public static TrashDropAllFsEvent parse(TskvEventLogLine tskv) {
        return new TrashDropAllFsEvent(tskv.getMetadata(), tskv.getPassportUid("owner"));
    }

    @Override
    public EventType getEventType() {
        return EventType.FS_TRASH_DROP_ALL;
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list();
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list();
    }
}
