package ru.yandex.chemodan.eventlog.events.invite;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ActivationInviteEvent extends AbstractInviteEvent {
    @BenderPart(name="owner_uid", strictName = true)
    public final Option<MpfsUid> owner;

    @BenderPart(name="user_uid", strictName = true)
    public final Option<MpfsUid> user;

    public ActivationInviteEvent(EventMetadata metadata, String project) {
        this(metadata, project, Option.empty(), Option.empty());
    }

    private ActivationInviteEvent(EventMetadata metadata, String project, Option<MpfsUid> owner, Option<MpfsUid> user) {
        super(metadata, project);
        this.owner = owner;
        this.user = user;
    }

    public static ActivationInviteEvent parse(TskvEventLogLine tskv) {
        return new ActivationInviteEvent(
                tskv.getMetadata(),
                tskv.getString("project"),
                tskv.getPassportUidO("owner_uid"),
                Option.empty());
    }

    public ActivationInviteEvent withOwner(MpfsUid owner) {
        return new ActivationInviteEvent(this.metadata, this.project, Option.of(owner), this.user);
    }

    public ActivationInviteEvent withUser(MpfsUid user) {
        return new ActivationInviteEvent(this.metadata, this.project, this.owner, Option.of(user));
    }

    @Override
    public EventType getEventType() {
        return EventType.INVITE_ACTIVATION;
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list(project);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return metadata.cloudRequestId.map(requestId -> requestId.id);
    }

    @Override
    protected ListF<AbstractEvent> createExtraEvents() {
        return Cf.<AbstractEvent>list().plus(invert());
    }

    private Option<ActivationInviteEvent> invert() {
        if (owner.isPresent()) {
            return Option.of(
                    new ActivationInviteEvent(metadata.withUid(owner.get()), this.project)
                            .withUser(metadata.uid)
            );
        } else if (user.isPresent()) {
            return Option.of(
                    new ActivationInviteEvent(metadata.withUid(user.get()), this.project)
                            .withOwner(metadata.uid)
            );
        } else {
            return Option.empty();
        }
    }
}
