package ru.yandex.chemodan.eventlog.events.invite;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.UniverseInvite;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class SentInviteEvent extends AbstractInviteEvent {
    @BenderFlatten
    public final UniverseInvite invite;

    public SentInviteEvent(EventMetadata metadata, String project, UniverseInvite invite) {
        super(metadata, project);
        this.invite = invite;
    }

    public static SentInviteEvent parse(TskvEventLogLine tskv) {
        return new SentInviteEvent(
                tskv.getMetadata(),
                tskv.getString("project"),
                tskv.getUniverseInvite("address", "provider")
        );
    }

    @Override
    public EventType getEventType() {
        return EventType.INVITE_SENT;
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list()
                .plus(project);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list(invite.getService(), invite.getLogin());
    }
}
