package ru.yandex.chemodan.eventlog.events.lenta;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;

/**
 * Dummy event for all read but unhandled logs, since we need to create an event for every log line
 * @author bursy
 */
public class LentaLogDummyEvent extends AbstractEvent {
    public static final LentaLogDummyEvent INSTANCE = new LentaLogDummyEvent(null);

    private LentaLogDummyEvent(EventMetadata metadata) {
        super(metadata);
    }

    public EventType getEventType() {
        return EventType.SKIP;
    }

    public ListF<Object> getGroupChunks() {
        throw new NotImplementedException();
    }

    public ListF<Object> getNameChunks() {
        throw new NotImplementedException();
    }
}
