package ru.yandex.chemodan.eventlog.events.lenta.actiontype;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.lenta.share.SharedFolderInviteEvent;
import ru.yandex.chemodan.eventlog.events.lenta.share.SharedFolderInviteEventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author bursy
 */
public enum BlockCreatePinnedActionEventType implements LentaActionEventType {
    SHARE_INVITE_USER("share-invite-user", (line -> SharedFolderInviteEvent.parse(line, SharedFolderInviteEventType.RECEIVED)))
    ;

    public final String value;
    public final Function<TskvEventLogLine, AbstractEvent> parser;

    BlockCreatePinnedActionEventType(String value, Function<TskvEventLogLine, AbstractEvent> parser) {
        this.value = value;
        this.parser = parser;
    }

    @Override
    public String value() {
        return value;
    }

    @Override
    public AbstractEvent parseToAbstractEvent(TskvEventLogLine line) {
        return parser.apply(line);
    }

    public static final StringEnumResolver<BlockCreatePinnedActionEventType> R =
            StringEnumResolver.r(BlockCreatePinnedActionEventType.class);
}
