package ru.yandex.chemodan.eventlog.events.lenta.share;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author bursy
 */
public class SharedFolderInviteEvent extends AbstractEvent {
    @BenderIgnore
    public final SharedFolderInviteEventType eventType;
    @BenderPart(name = "lenta_block_id", strictName = true)
    public final String lentaBlockId;

    public SharedFolderInviteEvent(SharedFolderInviteEventType eventType, EventMetadata metadata, String lentaBlockId) {
        super(metadata);
        this.eventType = eventType;
        this.lentaBlockId = lentaBlockId;
    }

    @Override
    public EventType getEventType() {
        return eventType.getEventType();
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list(lentaBlockId);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list();
    }

    public static SharedFolderInviteEvent parse(TskvEventLogLine tskv, SharedFolderInviteEventType type) {
        return new SharedFolderInviteEvent(
                type,
                tskv.getMetadata(),
                tskv.getString("block_id"));
    }
}
