package ru.yandex.chemodan.eventlog.events.lenta.share;

import ru.yandex.chemodan.eventlog.events.EventType;

/**
 * @author bursy
 */
public enum SharedFolderInviteEventType {
    /**
     * Owner shared a folder with user
     */
    RECEIVED(EventType.SHARE_INVITE_USER),
    /**
     * User accepted invite to folder from owner
     */
    ACCEPTED(EventType.SHARE_ACTIVATE_INVITE)
    ;

    private EventType eventType;

    SharedFolderInviteEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public EventType getEventType() {
        return eventType;
    }
}
