package ru.yandex.chemodan.eventlog.events.misc;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.CompoundResourceType;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.MediaType;
import ru.yandex.chemodan.eventlog.events.ResourceType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;

/**
 * @author dbrylev
 */
public class PublicVisitEvent extends AbstractEvent {

    public final String shortUrl;
    public final Option<CompoundResourceType> resourceType;

    public final Option<Boolean> isOwner;
    public final Option<Boolean> isInvitee;

    public PublicVisitEvent(
            EventMetadata metadata, String shortUrl,
            Option<CompoundResourceType> resourceType,
            Option<Boolean> isOwner, Option<Boolean> isInvitee)
    {
        super(metadata);
        this.shortUrl = shortUrl;
        this.resourceType = resourceType;
        this.isOwner = isOwner;
        this.isInvitee = isInvitee;
    }

    public static PublicVisitEvent parse(TskvEventLogLine tskv) {
        Option<String> type = tskv.getNonEmptyStringO("resource_type");
        Option<String> mediaType = tskv.getNonEmptyStringO("resource_media_type");

        return new PublicVisitEvent(tskv.getMetadata(),
                tskv.getNonEmptyString("short_url"),
                type.map(t -> new CompoundResourceType(ResourceType.R.fromValue(t), mediaType.map(MediaType::new))),
                tskv.getBooleanO("uid_is_owner"),
                tskv.getBooleanO("uid_is_invited"));
    }

    @Override
    public EventType getEventType() {
        return EventType.PUBLIC_VISIT;
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list();
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list();
    }
}
