package ru.yandex.chemodan.eventlog.events.sharing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.MpfsAddress;
import ru.yandex.chemodan.eventlog.events.TargetInfo;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ShareData extends DefaultObject {
    @BenderPart(name = "owner_uid", strictName = true)
    public final MpfsUid owner;

    @BenderIgnore
    public final String groupId;

    @BenderIgnore
    public final MpfsAddress target;

    @BenderFlatten
    public final TargetInfo targetInfo;

    @BenderIgnore
    public final ShareUserType currentUserType;

    @BenderIgnore
    public final Option<String> inviteHash;

    public ShareData(
            EventMetadata metadata, MpfsUid owner, String groupId, MpfsAddress target,
            boolean isInvite, Option<String> inviteHash)
    {
        this.owner = owner;
        this.groupId = groupId;
        this.target = target;
        this.targetInfo = TargetInfo.fromAddress(metadata.uid, target);
        this.currentUserType = ShareUserType.byIsOwnerAndIsInvite(metadata.uid.equals(owner), isInvite);
        this.inviteHash = inviteHash;
    }
}
