package ru.yandex.chemodan.eventlog.events.sharing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventTypeResolver;
import ru.yandex.chemodan.eventlog.log.TskvEventType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum ShareEventType implements SpecificEventType {
    CREATE_GROUP(TskvEventType.SHARE_CREATE_GROUP, EventType.SHARE_CREATE_GROUP),
    UNSHARE_FOLDER(TskvEventType.SHARE_UNSHARE_FOLDER, event -> {
        if (event.isOwnerEvent()) {
            return EventType.SKIP;
        }

        if (event.data.currentUserType == ShareUserType.INVITEE) {
            return EventType.SHARE_REMOVE_INVITE;
        } else {
            return EventType.SHARE_KICK_FROM_GROUP;
        }
    }
    ),
    UNSHARE_FOLDER_USER(TskvEventType.SHARE_UNSHARE_FOLDER_USER, EventType.SHARE_UNSHARE_FOLDER_USER,
            ShareUserType.SUBSCRIBER),
    UNSHARE_FOLDER_INVITEE(TskvEventType.SHARE_UNSHARE_FOLDER_INVITEE, EventType.SHARE_UNSHARE_FOLDER_USER,
            ShareUserType.INVITEE),
    INVITE_USER(TskvEventType.SHARE_INVITE_USER, EventType.SHARE_INVITE_USER, ShareUserType.INVITEE),
    REMOVE_INVITE(TskvEventType.SHARE_REMOVE_INVITE, EventType.SHARE_REMOVE_INVITE, ShareUserType.INVITEE),
    CHANGE_INVITE_RIGHTS(TskvEventType.SHARE_CHANGE_INVITE_RIGHTS, EventType.SHARE_CHANGE_INVITE_RIGHTS,
            ShareUserType.INVITEE),
    CHANGE_RIGHTS(TskvEventType.SHARE_CHANGE_RIGHTS, EventType.SHARE_CHANGE_RIGHTS, ShareUserType.SUBSCRIBER),
    KICK_FROM_GROUP(TskvEventType.SHARE_KICK_FROM_GROUP, EventType.SHARE_KICK_FROM_GROUP, ShareUserType.SUBSCRIBER),
    CHANGE_GROUP_OWNER(TskvEventType.SHARE_CHANGE_GROUP_OWNER, EventType.SHARE_CHANGE_GROUP_OWNER),
    ACTIVATE_INVITE(TskvEventType.SHARE_ACTIVATE_INVITE, EventType.SHARE_ACTIVATE_INVITE, ShareUserType.INVITEE),
    REJECT_INVITE(TskvEventType.SHARE_REJECT_INVITE, EventType.SHARE_REJECT_INVITE, ShareUserType.INVITEE),
    LEAVE_GROUP(TskvEventType.SHARE_LEAVE_GROUP, EventType.SHARE_LEAVE_GROUP, ShareUserType.SUBSCRIBER),
    ;

    final TskvEventType tskvType;

    final Function<ShareEvent, EventType> globalTypeF;

    final Option<ShareUserType> userType;

    ShareEventType(TskvEventType tskvType, EventType globalType) {
        this(tskvType, event -> globalType, Option.empty());
    }

    ShareEventType(TskvEventType tskvType, EventType globalType, ShareUserType userType) {
        this(tskvType, event -> globalType, userType);
    }

    ShareEventType(TskvEventType tskvType, Function<ShareEvent, EventType> globalTypeF) {
        this(tskvType, globalTypeF, Option.empty());
    }

    ShareEventType(TskvEventType tskvType, Function<ShareEvent, EventType> globalTypeF, ShareUserType userType) {
        this(tskvType, globalTypeF, Option.of(userType));
    }

    ShareEventType(TskvEventType tskvType, Function<ShareEvent, EventType> globalTypeF,
            Option<ShareUserType> userType)
    {
        this.tskvType = tskvType;
        this.globalTypeF = globalTypeF;
        this.userType = userType;
    }

    public final EventType getGlobalType(ShareEvent event) {
        return globalTypeF.apply(event);
    }

    @Override
    public TskvEventType getTskvType() {
        return tskvType;
    }

    public static final SpecificEventTypeResolver<ShareEventType> R = new SpecificEventTypeResolver<>(values());
}
