package ru.yandex.chemodan.eventlog.events.sharing;

import ru.yandex.bolts.collection.Either;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.UniverseInvite;
import ru.yandex.chemodan.mpfs.MpfsUid;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public final class ShareEvents {
    public static ShareEvent createGroup(EventMetadata metadata, ShareData data) {
        return new ShareEvent(ShareEventType.CREATE_GROUP, metadata, data);
    }

    public static ShareEvent unshareFolder(EventMetadata metadata, ShareData data) {
        return new ShareEvent(ShareEventType.UNSHARE_FOLDER, metadata, data);
    }

    public static ShareEvent unshareFolderUser(EventMetadata metadata, ShareData data, MpfsUid user) {
        return new ShareEvent(ShareEventType.UNSHARE_FOLDER_USER, metadata, data, user);
    }

    public static ShareEvent unshareFolderInvitee(EventMetadata metadata, ShareData data, MpfsUid user) {
        return new ShareEvent(ShareEventType.UNSHARE_FOLDER_INVITEE, metadata, data, user);
    }

    public static ShareEvent changeRights(EventMetadata metadata, ShareData data, MpfsUid user,
            ShareRightsChange rights)
    {
        return new ShareEvent(ShareEventType.CHANGE_RIGHTS, metadata, data, user, rights);
    }

    public static ShareEvent activateInvite(EventMetadata metadata, ShareData data, MpfsUid user, ShareRights rights) {
        return new ShareEvent(ShareEventType.ACTIVATE_INVITE, metadata, data, user,
                new ShareRightsChange(rights));
    }

    public static ShareEvent changeGroupOwner(EventMetadata metadata, ShareData data, MpfsUid user) {
        return new ShareEvent(ShareEventType.CHANGE_GROUP_OWNER, metadata, data, user);
    }

    public static ShareEvent kickFromGroup(EventMetadata metadata, ShareData data, MpfsUid user) {
        return new ShareEvent(ShareEventType.KICK_FROM_GROUP, metadata, data, user);
    }

    public static ShareEvent leaveGroup(EventMetadata metadata, ShareData data, MpfsUid user) {
        return new ShareEvent(ShareEventType.LEAVE_GROUP, metadata, data, user);
    }

    public static ShareEvent rejectInvite(EventMetadata metadata, ShareData data, MpfsUid user) {
        return new ShareEvent(ShareEventType.REJECT_INVITE, metadata, data, user);
    }

    public static ShareEvent removeInvite(EventMetadata metadata, ShareData data,
            Either<MpfsUid, UniverseInvite> userOrInvite) {
        return new ShareEvent(ShareEventType.REMOVE_INVITE, metadata, data, userOrInvite, ShareRightsChange.NONE);
    }

    public static ShareEvent changeInviteRights(EventMetadata metadata, ShareData data,
            Either<MpfsUid, UniverseInvite> userOrInvite, ShareRightsChange rightsChange) {
        return new ShareEvent(ShareEventType.CHANGE_INVITE_RIGHTS, metadata, data, userOrInvite, rightsChange);
    }

    public static ShareEvent inviteUser(EventMetadata metadata, ShareData data,
            Either<MpfsUid, UniverseInvite> userOrInvite, ShareRights rights) {
        return new ShareEvent(ShareEventType.INVITE_USER, metadata, data, userOrInvite,
                new ShareRightsChange(rights));
    }

    private ShareEvents() {}
}
