package ru.yandex.chemodan.eventlog.events.sharing;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum ShareRights implements IntEnum {
    READ_ONLY(640), WRITE(660);

    private final int value;

    ShareRights(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<ShareRights> R = IntEnumResolver.r(ShareRights.class);
}
