package ru.yandex.chemodan.eventlog.events.sharing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ShareRightsChange extends DefaultObject {
    public static final ShareRightsChange NONE = new ShareRightsChange(Option.empty(), Option.empty());

    @BenderPart(name = "rights", strictName = true)
    public final Option<ShareRights> rights;

    @BenderPart(name = "prev_rights", strictName = true)
    public final Option<ShareRights> prevRights;

    public ShareRightsChange(ShareRights rights) {
        this(Option.of(rights), Option.empty());
    }

    public ShareRightsChange(ShareRights rights, ShareRights prevRights) {
        this(Option.of(rights), Option.of(prevRights));
    }

    private ShareRightsChange(Option<ShareRights> rights, Option<ShareRights> prevRights) {
        this.rights = rights;
        this.prevRights = prevRights;
    }

    public static ShareRightsChange cons(Option<ShareRights> rights, Option<ShareRights> prevRights) {
        if (rights.isPresent() || prevRights.isPresent()) {
            return new ShareRightsChange(rights, prevRights);
        } else {
            return NONE;
        }
    }
}
