package ru.yandex.chemodan.eventlog.events.sharing;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum ShareUserType {
    OWNER, SUBSCRIBER, INVITEE;

    public static ShareUserType byIsOwnerAndIsInvite(boolean isOwner, boolean isInvite) {
        if (isOwner) {
            if (isInvite) {
                throw new IllegalArgumentException("Owner could not be invitee");
            }

            return OWNER;
        } else {
            if (isInvite) {
                return INVITEE;
            } else {
                return SUBSCRIBER;
            }
        }
    }
}
