package ru.yandex.chemodan.eventlog.events.sharing;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ShareUserTypeTest {
    @Test
    public void testByOwner() {
        Assert.equals(ShareUserType.OWNER, ShareUserType.byIsOwnerAndIsInvite(true, false));
    }

    @Test
    public void testBySubscriber() {
        Assert.equals(ShareUserType.SUBSCRIBER, ShareUserType.byIsOwnerAndIsInvite(false, false));
    }

    @Test
    public void testByInvitee() {
        Assert.equals(ShareUserType.INVITEE, ShareUserType.byIsOwnerAndIsInvite(false, true));
    }

    @Test(expected = IllegalArgumentException.class)
    public void testIllegalArgument() {
        ShareUserType.byIsOwnerAndIsInvite(true, true);
    }
}
