package ru.yandex.chemodan.eventlog.events.space;

import java.math.BigInteger;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class AbstractSpaceEvent extends AbstractEvent {
    private final SpaceEventType eventType;

    @BenderPart(name = "old_limit", strictName = true)
    public final BigInteger oldLimit;

    @BenderPart(name = "new_limit", strictName = true)
    public final BigInteger newLimit;

    protected AbstractSpaceEvent(SpaceEventType eventType, EventMetadata metadata,
            BigInteger oldLimit, BigInteger newLimit)
    {
        super(metadata);
        this.eventType = eventType;
        this.oldLimit = oldLimit;
        this.newLimit = newLimit;
    }

    public static AbstractSpaceEvent parse(TskvEventLogLine tskv) {
        if (tskv.hasKey("product_id")) {
            return new ProductSpaceEvent(
                    SpaceEventType.R.byTskvType(tskv.getEventType()),
                    tskv.getMetadata(),
                    tskv.getBigInteger("old_limit"),
                    tskv.getBigInteger("new_limit"),
                    tskv.getProduct()
            );
        } else {
            return new BasicSpaceEvent(
                    SpaceEventType.R.byTskvType(tskv.getEventType()),
                    tskv.getMetadata(),
                    tskv.getBigInteger("old_limit"),
                    tskv.getBigInteger("new_limit"),
                    tskv.getNonEmptyStringO("reason")
            );
        }
    }

    public abstract boolean isFree();

    protected abstract Option<String> getIdOrReasonO();

    @Override
    public EventType getEventType() {
        return eventType.getGlobalType(this);
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list();
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list().plus1(getIdOrReasonO());
    }
}
