package ru.yandex.chemodan.eventlog.events.space;

import java.math.BigInteger;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class BasicSpaceEvent extends AbstractSpaceEvent {
    @BenderPart(name = "product_id", strictName = true)
    public final Option<String> reason;

    public BasicSpaceEvent(SpaceEventType eventType, EventMetadata metadata, BigInteger oldLimit, BigInteger newLimit,
            Option<String> reason) {
        super(eventType, metadata, oldLimit, newLimit);
        this.reason = reason;
    }

    @Override
    public boolean isFree() {
        return true;
    }

    @Override
    protected Option<String> getIdOrReasonO() {
        return reason;
    }
}
