package ru.yandex.chemodan.eventlog.events.space;

import java.math.BigInteger;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.billing.Product;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ProductSpaceEvent extends AbstractSpaceEvent {
    @BenderFlatten
    public final Product product;

    public ProductSpaceEvent(SpaceEventType eventType, EventMetadata metadata, BigInteger oldLimit, BigInteger newLimit,
            Product product)
    {
        super(eventType, metadata, oldLimit, newLimit);
        this.product = product;
    }

    @Override
    public boolean isFree() {
        return product.free;
    }

    @Override
    protected Option<String> getIdOrReasonO() {
        return Option.of(product.id);
    }
}
