package ru.yandex.chemodan.eventlog.events.space;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventTypeResolver;
import ru.yandex.chemodan.eventlog.log.TskvEventType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum SpaceEventType implements SpecificEventType {
    ENLARGE(TskvEventType.SPACE_ENLARGE, event -> event.isFree() ? EventType.SPACE_PROMO_ENLARGE : EventType.SKIP),
    REDUCE(TskvEventType.SPACE_REDUCE,
            event -> event.isFree() ? EventType.SPACE_PROMO_REDUCE: EventType.SPACE_PRODUCT_REDUCE);

    private final Function<AbstractSpaceEvent, EventType> globalTypeF;

    private final TskvEventType tskvType;

    SpaceEventType(TskvEventType tskvType, Function<AbstractSpaceEvent, EventType> globalTypeF) {
        this.tskvType = tskvType;
        this.globalTypeF = globalTypeF;
    }

    @Override
    public TskvEventType getTskvType() {
        return tskvType;
    }

    public EventType getGlobalType(AbstractSpaceEvent event) {
        return globalTypeF.apply(event);
    }

    public static final SpecificEventTypeResolver<SpaceEventType> R = new SpecificEventTypeResolver<>(values());
}
