package ru.yandex.chemodan.eventlog.log;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.client.MetricsEvent;

public class TskvClientMetricsEventLogLine extends TskvEventLogLine {

    public static final String EVENT_TYPE = "EventType";

    public static TskvClientMetricsEventLogLine parse(String line) {
        return new TskvClientMetricsEventLogLine(TskvLogLine.parse(line));
    }

    public TskvClientMetricsEventLogLine(TskvLogLine tskv) {
        super(tskv);
    }

    public Option<MetricsEvent> toMetricsEvent() {
        return Option.of(MetricsEvent.parse(this));
    }

    @Override
    protected String getEventTypeFieldName() {
        return EVENT_TYPE;
    }
}
