package ru.yandex.chemodan.eventlog.log;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TskvEventLogLineTest {
    public static final String UNKNOWN_EVENT_TYPE_LOG_LINE = "tskv\tevent_type=some_unknown_type";

    public static final String MISSING_EVENT_TYPE_LOG_LINE = "tskv\tno_event_type_here";

    @Test
    public void toEventMustReturnNoneOptionForUnknownEventTypes() {
        Assert.isEmpty(TskvEventLogLine.parse(UNKNOWN_EVENT_TYPE_LOG_LINE).toEvent());
    }

    @Test(expected = java.util.NoSuchElementException.class)
    public void toEventMustFailOnMissingEventType() {
        TskvEventLogLine.parse(MISSING_EVENT_TYPE_LOG_LINE).toEvent();
    }
}
