package ru.yandex.chemodan.eventlog.log;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.commentaries.CommentsTskvAction;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.album.AbstractAlbumItemEvent;
import ru.yandex.chemodan.eventlog.events.album.ChangeCoverAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ChangeCoverOffsetAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ChangePublicityAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ChangeTitleAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.CreateAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.PostToSocialAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.RemoveAlbumEvent;
import ru.yandex.chemodan.eventlog.events.billing.BillingEvent;
import ru.yandex.chemodan.eventlog.events.comment.CommentEvent;
import ru.yandex.chemodan.eventlog.events.comment.LikeDislikeEvent;
import ru.yandex.chemodan.eventlog.events.fs.DeleteSubdirFsEvent;
import ru.yandex.chemodan.eventlog.events.fs.FsEvent;
import ru.yandex.chemodan.eventlog.events.fs.MksysdirFsEvent;
import ru.yandex.chemodan.eventlog.events.fs.TrashDropAllFsEvent;
import ru.yandex.chemodan.eventlog.events.invite.ActivationInviteEvent;
import ru.yandex.chemodan.eventlog.events.invite.SentInviteEvent;
import ru.yandex.chemodan.eventlog.events.lenta.LentaLogEventParser;
import ru.yandex.chemodan.eventlog.events.lenta.LentaTskvEventType;
import ru.yandex.chemodan.eventlog.events.misc.PublicVisitEvent;
import ru.yandex.chemodan.eventlog.events.sharing.ShareEvent;
import ru.yandex.chemodan.eventlog.events.space.ProductSpaceEvent;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum TskvEventType implements StringEnum {
    // События файловой системы
    FS_MKSYSDIR("fs-mksysdir", MksysdirFsEvent::parse),
    FS_MKDIR("fs-mkdir", FsEvent::parse),
    FS_STORE("fs-store", FsEvent::parse),
    FS_HARDLINK_COPY("fs-hardlink-copy", FsEvent::parse),
    FS_COPY("fs-copy", FsEvent::parse),
    FS_MOVE("fs-move", FsEvent::parse),
    FS_RM("fs-rm", FsEvent::parse),
    FS_TRASH_APPEND("fs-trash-append", FsEvent::parse),
    FS_TRASH_RESTORE("fs-trash-restore", FsEvent::parse),
    FS_TRASH_DROP("fs-trash-drop", FsEvent::parse),
    FS_TRASH_DROP_ALL("fs-trash-drop-all", TrashDropAllFsEvent::parse),

    FS_DELETE_SUBDIR("fs-delete-subdir", DeleteSubdirFsEvent::parse),

    // События публикации
    FS_SET_PUBLIC("fs-set-public", FsEvent::parse),
    FS_SET_PRIVATE("fs-set-private", FsEvent::parse),

    // операции с общими папками
    SHARE_CREATE_GROUP("share-create-group", ShareEvent::parse),
    SHARE_INVITE_USER("share-invite-user", ShareEvent::parse),
    SHARE_REMOVE_INVITE("share-remove-invite", ShareEvent::parse),
    SHARE_CHANGE_INVITE_RIGHTS("share-change-invite-rights", ShareEvent::parse),
    SHARE_CHANGE_RIGHTS("share-change-rights", ShareEvent::parse),
    SHARE_KICK_FROM_GROUP("share-kick-from-group", ShareEvent::parse),
    SHARE_CHANGE_GROUP_OWNER("share-change-group-owner", ShareEvent::parse),
    SHARE_ACTIVATE_INVITE("share-activate-invite", ShareEvent::parse),
    SHARE_REJECT_INVITE("share-reject-invite", ShareEvent::parse),
    SHARE_LEAVE_GROUP("share-leave-group", ShareEvent::parse),
    SHARE_UNSHARE_FOLDER("share-unshare-folder", ShareEvent::parse),
    SHARE_UNSHARE_FOLDER_USER("share-unshare-folder-user", ShareEvent::parse),
    SHARE_UNSHARE_FOLDER_INVITEE("share-unshare-folder-invitee", ShareEvent::parse),

    // Операции над альбомами
    ALBUM_CREATE("album-create", CreateAlbumEvent::parse),
    ALBUM_REMOVE("album-remove", RemoveAlbumEvent::parse),
    ALBUM_CREATE_ITEM("album-create-item", AbstractAlbumItemEvent::parse),
    ALBUM_ITEMS_APPEND("album-items-append", AbstractAlbumItemEvent::parse),
    ALBUM_ITEMS_REMOVE("album-items-remove", AbstractAlbumItemEvent::parse),
    ALBUM_CHANGE_PUBLICITY("album-change-publicity", ChangePublicityAlbumEvent::parse),
    ALBUM_CHANGE_COVER("album-change-cover", ChangeCoverAlbumEvent::parse),
    ALBUM_CHANGE_COVER_OFFSET("album-change-cover-offset", ChangeCoverOffsetAlbumEvent::parse),
    ALBUM_CHANGE_TITLE("album-change-title", ChangeTitleAlbumEvent::parse),
    ALBUM_POST_TO_SOCIAL("album-post-to-social", PostToSocialAlbumEvent::parse),

    // События биллинга
    BILLING_BUY_NEW("billing-buy-new", BillingEvent::parse),
    BILLING_ORDER_NEW("billing-order-new", BillingEvent::parse),
    BILLING_DELETE("billing-delete", BillingEvent::parse),
    BILLING_PROLONG("billing-prolong", BillingEvent::parse),
    BILLING_UNSUBSCRIBE("billing-unsubscribe", BillingEvent::parse),

    // Инвайты
    INVITE_SENT("invite-sent", SentInviteEvent::parse),
    INVITE_ACTIVATION("invite-activation", ActivationInviteEvent::parse),

    // Дисковое пространство
    SPACE_ENLARGE("space-enlarge", ProductSpaceEvent::parse),
    SPACE_REDUCE("space-reduce", ProductSpaceEvent::parse),

    // Комментарии
    COMMENT_ADD(CommentsTskvAction.COMMENT_ADD.value(), CommentEvent::parse),
    COMMENT_DELETE(CommentsTskvAction.COMMENT_DELETE.value(), CommentEvent::parse),
    COMMENT_RESTORE(CommentsTskvAction.COMMENT_RESTORE.value(), CommentEvent::parse),
    COMMENT_LIKE_ADD(CommentsTskvAction.LIKE_ADD.value(), LikeDislikeEvent::parse),
    COMMENT_LIKE_DELETE(CommentsTskvAction.LIKE_DELETE.value(), LikeDislikeEvent::parse),
    COMMENT_DISLIKE_ADD(CommentsTskvAction.DISLIKE_ADD.value(), LikeDislikeEvent::parse),
    COMMENT_DISLIKE_DELETE(CommentsTskvAction.DISLIKE_DELETE.value(), LikeDislikeEvent::parse),

    // Прочие ивенты
    PUBLIC_VISIT("public-visit", PublicVisitEvent::parse),

    // Логи ленты
    LENTA_BLOCK_CREATE_PINNED(LentaTskvEventType.BLOCK_CREATE_PINNED.value(), LentaLogEventParser::parse),
    LENTA_BLOCK_TASK_MERGED(LentaTskvEventType.BLOCK_TASK_MERGED.value(), LentaLogEventParser::parse),
    LENTA_BLOCK_TASK_SCHEDULED(LentaTskvEventType.BLOCK_TASK_SCHEDULED.value(), LentaLogEventParser::parse),
    LENTA_BLOCK_UPDATE_AND_UP(LentaTskvEventType.BLOCK_UPDATE_AND_UP.value(), LentaLogEventParser::parse),

    STUB("stub", line -> null),
    ;

    private final String value;

    private final Function<TskvEventLogLine, AbstractEvent> parser;

    TskvEventType(String value, Function<TskvEventLogLine, AbstractEvent> parser) {
        this.value = value;
        this.parser = parser;
    }

    @Override
    public String value() {
        return value;
    }

    AbstractEvent parseEvent(TskvEventLogLine line) {
        return parser.apply(line);
    }

    public static final StringEnumResolver<TskvEventType> R = StringEnumResolver.r(TskvEventType.class);
}
