package ru.yandex.chemodan.eventlog.log;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TskvLogLineTest {
    @Test
    public void testBlankStringIsEmpty() {
        assertNonEmptyStringOIsNone(" ");
    }

    @Test
    public void testNoneIsEmpty() {
        assertNonEmptyStringOIsNone("None");
    }

    @Test
    public void testWhitespacePaddedNoneIsEmpty() {
        assertNonEmptyStringOIsNone("  None   ");
    }

    @Test
    public void testNonEmptyStringOIsNotEmpty() {
        Assert.some(
                "Test",
                consSingleValue("key", "Test")
                        .getNonEmptyStringO("key")
        );
    }

    @Test
    public void testIsTrue() {
        Assert.isTrue(
                consSingleValue("key", "TRUE")
                        .getBoolean("key")
        );
    }

    @Test
    public void testIsFalse() {
        Assert.isFalse(
                consSingleValue("key", "False")
                        .getBoolean("key")
        );
    }

    private static void assertNonEmptyStringOIsNone(String value) {
        Assert.none(
                consSingleValue("key", value)
                        .getNonEmptyStringO("key")
        );
    }

    private static TskvLogLine consSingleValue(String key, String value) {
        return new TskvLogLine(Cf.map(key, value));
    }
}
