package ru.yandex.chemodan.grpc;

import io.grpc.Metadata;

import ru.yandex.inside.passport.tvm2.TvmHeaders;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.inside.passport.tvm2.web.Tvm2ServletFilterContextConfiguration;

public class TvmGrpcHeaders {

    public static final Metadata.Key<String> TVM2_SERVICE_TICKET =
            Metadata.Key.of(TvmHeaders.SERVICE_TICKET, Metadata.ASCII_STRING_MARSHALLER);

    public static final Metadata.Key<String> TVM2_USER_TIKET =
            Metadata.Key.of(TvmHeaders.USER_TICKET, Metadata.ASCII_STRING_MARSHALLER);

    public static final Metadata.Key<String> TVM_CLIENT_ID =
            Metadata.Key.of(Tvm2Filter.TVM_CLIENT_ID_ATTR, Metadata.ASCII_STRING_MARSHALLER);

    public static final Metadata.Key<String> TVM_REQUIRED =
            Metadata.Key.of(Tvm2Filter.TVM_REQUIRED_HEADER, Metadata.ASCII_STRING_MARSHALLER);

    public static final Metadata.Key<String> TVM_UID =
            Metadata.Key.of(Tvm2ServletFilterContextConfiguration.X_UID, Metadata.ASCII_STRING_MARSHALLER);
}
