package ru.yandex.chemodan.grpc.client;

import java.util.concurrent.TimeUnit;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;

public class DeadlineInterceptor implements ClientInterceptor {

    private final long deadlineMs;

    public DeadlineInterceptor(long deadlineMs) {
        this.deadlineMs = deadlineMs;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method,
            CallOptions callOptions, Channel next)
    {
        return next.newCall(method, callOptions.withDeadlineAfter(deadlineMs, TimeUnit.MILLISECONDS));
    }
}
