package ru.yandex.chemodan.grpc.client;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.grpc.client.data.GrpcChannelConfiguration;
import ru.yandex.inside.passport.tvm2.Tvm2;

public class GrpcChannelBuilder {

    private final int tvmDstClient;
    private final Option<Tvm2> tvm2O;

    public GrpcChannelBuilder(int tvmDstClient, Option<Tvm2> tvm2O) {
        this.tvmDstClient = tvmDstClient;
        this.tvm2O = tvm2O;
    }

    public ManagedChannel buildChannel(GrpcChannelConfiguration channelConfiguration) {
        ListF<ClientInterceptor> interceptors = Cf.arrayList();
        interceptors.add(new LoggingGrpcInterceptor(
                channelConfiguration.getRequestIdPrefix(),
                Metadata.Key.of(channelConfiguration.getTracingMetadataKeyName(), Metadata.ASCII_STRING_MARSHALLER),
                channelConfiguration.getEnableLoggingVerboseMode()));
        tvm2O.map(tvm2 -> new Tvm2GrpcClientInterceptor(tvmDstClient, tvm2)).ifPresent(interceptors::add);
        interceptors.addAll(channelConfiguration.getCustomInterceptors());
        ManagedChannelBuilder<?> builder =
                ManagedChannelBuilder.forAddress(channelConfiguration.getHost(), channelConfiguration.getPort())
                        .intercept(interceptors.unmodifiable());

        Option.ofNullable(channelConfiguration.getSslServerName()).ifPresent(builder::overrideAuthority);

        return builder.build();
    }
}
