package ru.yandex.chemodan.grpc.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.passport.tvm2.Tvm2;

import static ru.yandex.chemodan.grpc.TvmGrpcHeaders.TVM2_SERVICE_TICKET;

public class Tvm2GrpcClientInterceptor implements ClientInterceptor {

    private final int dstTvmClient;

    private final Tvm2 tvm2;

    public Tvm2GrpcClientInterceptor(int dstTvmClient, Tvm2 tvm2) {
        this.dstTvmClient = dstTvmClient;
        this.tvm2 = tvm2;
        tvm2.addDstClientIds(Cf.list(dstTvmClient));
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)) {
            @Override
            public void start(Listener<RespT> responseListener, Metadata headers) {
                Metadata tvm2Metadata = new Metadata();
                tvm2.getServiceTicket(dstTvmClient).ifPresent(serviceTicket -> tvm2Metadata.put(TVM2_SERVICE_TICKET, serviceTicket));
                headers.merge(tvm2Metadata);
                super.start(responseListener, headers);
            }
        };
    }


}
