package ru.yandex.chemodan.grpc.client.data;

import javax.annotation.Nullable;

import com.google.common.base.Supplier;
import io.grpc.ClientInterceptor;
import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.ListF;

@Data
@Builder
public class GrpcChannelConfiguration {

    private final String host;

    private final int port;

    @Nullable
    private final String sslServerName;

    private final ListF<ClientInterceptor> customInterceptors;

    private final String requestIdPrefix;

    private final String tracingMetadataKeyName;

    private final Supplier<Boolean> enableLoggingVerboseMode;

}
