package ru.yandex.chemodan.grpc.server.interceptors;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.grpc.CommonGrpcHeaders;
import ru.yandex.chemodan.http.YandexCloudRequestIdHandler;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.version.AppName;

import static ru.yandex.chemodan.grpc.GrpcContextCommonKeys.REQUEST_ID;
import static ru.yandex.chemodan.grpc.GrpcContextCommonKeys.YCRID;

public class ContextGrpcServerInterceptor implements ServerInterceptor {

    private final AppName appName;

    public ContextGrpcServerInterceptor(AppName appName) {
        this.appName = appName;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call,
            Metadata headers, ServerCallHandler<ReqT, RespT> next)
    {
        String ycrid = Option.ofNullable(headers.get(CommonGrpcHeaders.YCRID_METADATA_KEY))
                .getOrElse(() -> YandexCloudRequestIdHandler.generate(appName.appName()));
        Context context = Context.current()
                .withValue(REQUEST_ID, Random2.R.nextAlnum(8))
                .withValue(YCRID, ycrid);
        headers.put(CommonGrpcHeaders.YCRID_METADATA_KEY, ycrid);
        return Contexts.interceptCall(context, call, headers, next);
    }
}
