package ru.yandex.chemodan.app.lentaloader.cool.utils;

import org.joda.time.DateTime;

/**
 * @author tolmalev
 */
public class CoolTitlesUtils {
    public static DateTime getEndWithOffset(DateTime start, IntervalType type) {
        return type.getIntervalEnd(start).minusHours(1);
    }

    public static boolean isCrossYear(DateTime start, IntervalType type) {
        return start.getYear() != getEndWithOffset(start, type).getYear();
    }

    public static boolean isCrossMonth(DateTime start, IntervalType type) {
        return start.getMonthOfYear() != getEndWithOffset(start, type).getMonthOfYear();
    }
}
