package ru.yandex.chemodan.app.lentaloader.cool.utils;

import lombok.Data;
import org.joda.time.DateTime;
import org.joda.time.Duration;

/**
 * @author tolmalev
 */
@Data
public class GenerationInterval {
    public IntervalType type;
    public DateTime start;
    public DateTime end;

    public GenerationInterval(IntervalType type, DateTime timeInInterval) {
        this.type = type;
        this.start = type.getIntervalStart(timeInInterval);
        this.end = type.getIntervalEnd(start);
    }

    /**
     * Create minimal interval, covering both moments from parameters
     * @param minDate
     * @param maxDate
     */
    public GenerationInterval(DateTime minDate, DateTime maxDate) {
        this(TimeIntervalUtils.getMinimalInterval(minDate, maxDate), minDate);
    }

    public Duration getDistance(GenerationInterval interval) {
        long otherStart = interval.start.getMillis();
        long otherEnd = interval.end.getMillis();
        long thisStart = start.getMillis();
        long thisEnd = end.getMillis();

        if (thisStart > otherEnd) {
            return new Duration(otherEnd, thisStart);
        } else if (otherStart > thisEnd) {
            return new Duration(thisEnd, otherStart);
        } else {
            return Duration.ZERO;
        }
    }
}
