package ru.yandex.chemodan.app.lentaloader.cool.utils;

import ru.yandex.inside.utils.Language;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author tolmalev
 */
public interface GeoNamesSource {
    GeoNamesSource EMPTY = new GeoNamesSource() {
        @Override
        public String getGeoName(int regionId, Case c, Language language) {
            throw new IllegalStateException("Not implemented");
        }
    };

    String getGeoName(int regionId, Case c, Language language);

    enum Case {
        NOMINATIVE,
        GENITIVE,
        DATIVE,
        PREPOSITIONAL,
        PREPOSITION,
        LOCATIVE,
        DIRECTIONAL,
        ABLATIVE,
        ACCUSATIVE,
        INSTRUMENTAL;

        public static EnumResolver<Case> R = EnumResolver.er(Case.class);
    }
}
