package ru.yandex.chemodan.app.lentaloader.cool.utils;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author tolmalev
 */
public enum IntervalType {
    ONE_DAY(TimeIntervalUtils::getDayStart, TimeIntervalUtils::getDayEnd),
    WEEKEND(TimeIntervalUtils::getWeekendStart, TimeIntervalUtils::getWeekendEnd),
    WEEK(TimeIntervalUtils::getWeekStart, TimeIntervalUtils::getWeekEnd),
    MONTH(TimeIntervalUtils::getMonthStart, TimeIntervalUtils::getMonthEnd),
    SEASON(TimeIntervalUtils::getSeasonStart, TimeIntervalUtils::getSeasonEnd),
    YEAR(TimeIntervalUtils::getYearStart, TimeIntervalUtils::getYearEnd),
    WHOLE_TIME(
            time -> TimeIntervalUtils.getYearStart(time).withYear(1900),
            time -> TimeIntervalUtils.getYearStart(time).withYear(3000))
    ;

    private final Function<DateTime, DateTime> intervalStartF;
    private final Function<DateTime, DateTime> intervalEndF;

    IntervalType(Function<DateTime, DateTime> intervalStartF, Function<DateTime, DateTime> intervalEndF) {
        this.intervalStartF = intervalStartF;
        this.intervalEndF = intervalEndF;
    }

    public DateTime getIntervalStart(DateTime time) {
        return intervalStartF.apply(time);
    }

    public DateTime getIntervalEnd(DateTime time) {
        return intervalEndF.apply(time);
    }

    public static ListF<IntervalType> getTypesForDateTime(DateTime time) {
        ListF<IntervalType> result = Cf.x(values()).filter(v -> v != WHOLE_TIME);

        if (!TimeIntervalUtils.isInWeekend(time)) {
            result = result.filter(v -> v != WEEKEND);
        }

        return result.filter(type -> type.getIntervalStart(time).getMillis() > 0);
    }

    public String toBlockIdPart() {
        return name().toLowerCase();
    }

    public static final EnumResolver<IntervalType> R = EnumResolver.er(IntervalType.class);
}
