package ru.yandex.chemodan.app.lentaloader.cool.utils;

import org.joda.time.DateTime;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class TextProcessorTest {

    private TextProcessor processor = new TextProcessor(BlockTitlesGeneratorTest.createGeoNamesSource());

    @Test
    public void allGeo() {
        TitleGenerationContext context = new TitleGenerationContext(Random2.R, IntervalType.ONE_DAY, DateTime.now(), Cf.list(213, 187));

        Assert.equals("Москва и Украина", processor.processTemplate("{{geo:all.nominative}}", Language.RUSSIAN, context));

        Assert.equals("Москва и Украина", processor.processSimpleTemplate("geo:all.nominative", Language.RUSSIAN, context));
        Assert.equals("Москва", processor.processSimpleTemplate("geo:nominative", Language.RUSSIAN, context));
        Assert.equals("Москва", processor.processSimpleTemplate("geo:0.nominative", Language.RUSSIAN, context));
        Assert.equals("Украина", processor.processSimpleTemplate("geo:1.nominative", Language.RUSSIAN, context));
    }
}
