package ru.yandex.chemodan.app.lentaloader.cool.utils;


import lombok.Data;
import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.random.Random2;

/**
 * @author tolmalev
 */
@Data
public class TitleGenerationContext {

    public final Random2 R;
    public final IntervalType intervalType;
    public final DateTime start;
    public final DateTime end;
    public final ListF<Integer> geoIds;
    public final Option<TermDefinition> term;
    public final MapF<String, Object> attributes;

    public TitleGenerationContext(Random2 R, IntervalType intervalType, DateTime start) {
        this(R, intervalType, start, intervalType.getIntervalEnd(start), Cf.list(), Option.empty(), Cf.map());
    }

    public TitleGenerationContext(Random2 R, IntervalType intervalType, DateTime start, ListF<Integer> geoIds) {
        this(R, intervalType, start, intervalType.getIntervalEnd(start), geoIds, Option.empty(), Cf.map());
    }

    public TitleGenerationContext(Random2 R, IntervalType intervalType, DateTime start, ListF<Integer> geoIds,
            Option<TermDefinition> term)
    {
        this(R, intervalType, start, intervalType.getIntervalEnd(start), geoIds, term, Cf.map());
    }

    public TitleGenerationContext(Random2 R, DateTime start, DateTime end) {
        this(R, TimeIntervalUtils.getMinimalInterval(start, end), start, end, Cf.list(), Option.empty(), Cf.map());
    }

    public TitleGenerationContext(Random2 R, IntervalType intervalType, DateTime start, DateTime end,
            ListF<Integer> geoIds, Option<TermDefinition> term, MapF<String, Object> attributes) {
        this.R = R;
        this.intervalType = intervalType;
        this.start = start;
        this.end = end;
        this.geoIds = geoIds;
        this.term = term;
        this.attributes = attributes;
    }

    public TitleGenerationContext withAttribute(String name, Object value) {
        return new TitleGenerationContext(this.R, this.intervalType, this.start, this.end, this.geoIds, this.term,
                this.attributes.plus1(name, value));
    }

    public TitleGenerationContext withTerm(TermDefinition term) {
        return new TitleGenerationContext(this.R, this.intervalType, this.start, this.end, this.geoIds, Option.of(term),
                this.attributes);
    }
}
