/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package org.apache.log4j;

public class Priority {

    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int FATAL_INT = 50000;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    transient int level;
    transient String levelStr;
    transient int syslogEquivalent;

    protected Priority() {
        level = DEBUG_INT;
        levelStr = "DEBUG";
        syslogEquivalent = 7;
    }

    protected Priority(final int level, final String levelStr, final int syslogEquivalent) {
        this.level = level;
        this.levelStr = levelStr;
        this.syslogEquivalent = syslogEquivalent;
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof Priority) {
            final Priority r = (Priority) o;
            return this.level == r.level;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.level;
    }

    public boolean isGreaterOrEqual(final Priority r) {
        return level >= r.level;
    }

    @Deprecated
    public static Priority[] getAllPossiblePriorities() {
        return null;
    }

    @Override
    public final String toString() {
        return levelStr;
    }

    public final int toInt() {
        return level;
    }

}
