package ru.yandex.chemodan.logbroker;

import java.net.URI;

import org.joda.time.Duration;

import ru.yandex.chemodan.boot.value.OverridableValue;
import ru.yandex.inside.logbroker.pull.consumer.LbConsumerSettings2;
import ru.yandex.inside.logbroker.pull.model.LbTopicFilter;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class LbConsumerSettings2PrefixImpl extends LbConsumerSettings2 {
    @OverridableValue("${logbroker.listener.max-queue-size}")
    private int listenerMaxQueueSize;

    @OverridableValue("${logbroker.base-pull-url}")
    private URI lbBaseUrl;

    @OverridableValue("${logbroker.client-id}")
    private String lbClientId;

    @OverridableValue("${logbroker.session-batch-size}")
    private int lbSessionBatchSize;

    @OverridableValue("${logbroker.session-timeout}")
    private Duration lbSessionTimeout;

    @OverridableValue("${logbroker.read-wait}")
    private Duration lbReadWait;

    @OverridableValue("${logbroker.min-hard-commit-interval}")
    private Duration minHardCommitInterval;

    @OverridableValue("${logbroker.http.meta-host-timeout}")
    private Duration metaHostTimeout;

    @OverridableValue("${logbroker.http.data-host-timeout}")
    private Duration dataHostTimeout;

    public LbConsumerSettings2PrefixImpl(String dynamicPropertyPrefix, LbTopicFilter lbTopicFilter) {
        super(dynamicPropertyPrefix, lbTopicFilter);
    }

    @Override
    public int getListenerMaxQueueSize() {
        return listenerMaxQueueSize;
    }

    @Override
    public URI getLbBaseUrl() {
        return lbBaseUrl;
    }

    @Override
    public String getLbClientId() {
        return lbClientId;
    }

    @Override
    public int getLbSessionBatchSize() {
        return lbSessionBatchSize;
    }

    @Override
    public Duration getLbSessionTimeout() {
        return lbSessionTimeout;
    }

    @Override
    public Duration getLbReadWait() {
        return lbReadWait;
    }

    @Override
    public Duration getMinHardCommitInterval() {
        return minHardCommitInterval;
    }

    @Override
    public Duration getMetaHostTimeout() {
        return metaHostTimeout;
    }

    @Override
    public Duration getDataHostTimeout() {
        return dataHostTimeout;
    }
}
