package ru.yandex.chemodan.logbroker;

import org.joda.time.Duration;

import ru.yandex.inside.logbroker.push.PushClient;
import ru.yandex.misc.io.http.Timeout;

/**
 * @author tolmalev
 */
public class PushClientFactory {

    private final String server;
    private final int port;
    private final String ident;
    private final int sessionsCount;
    private final int threadsCount;
    private final Duration soTimeout;
    private final Duration connTimeout;

    public PushClientFactory(String server, int port, String ident, int sessionsCount, int threadsCount,
            Duration soTimeout, Duration connTimeout)
    {
        this.server = server;
        this.port = port;
        this.ident = ident;
        this.sessionsCount = sessionsCount;
        this.threadsCount = threadsCount;
        this.soTimeout = soTimeout;
        this.connTimeout = connTimeout;
    }

    public PushClient build(String logType) {
        return new PushClient(server, port, ident, logType, sessionsCount, threadsCount,
                new Timeout(soTimeout.getMillis(), connTimeout.getMillis()));
    }

    public PushClient buildAndStart(String logType) {
        PushClient client = build(logType);
        client.start();

        return client;
    }
}
