package ru.yandex.chemodan.logbroker;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author dbrylev
 */
@Configuration
public class PushClientFactoryContextConfiguration {

    @Value("${logbroker.host}")
    private String lbServer;

    @Value("${logbroker.port}")
    private int lbPort;

    @Value("${logbroker.ident}")
    private String lbIdent;

    @Value("${logbroker.push.sessions}")
    private int lbSessionsCount;

    @Value("${logbroker.push.threads}")
    private int lbThreadsCount;

    @Value("${logbroker.push.timeout.socket}")
    private Duration lbSoTimeout;

    @Value("${logbroker.push.timeout.connection}")
    private Duration lbConnTimeout;

    @Bean
    public PushClientFactory pushClientFactory() {
        return new PushClientFactory(
                lbServer, lbPort, lbIdent, lbSessionsCount, lbThreadsCount, lbSoTimeout, lbConnTimeout);
    }
}
