package ru.yandex.chemodan.app.notifier.metadata;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author buberman
 */
@BenderBindAllFields
public class MetadataEntity extends DefaultObject {
    public static final ListF<String> TRANSLATED_TEXT_FIELDS =
            NotifierLanguage.R.valuesList().map(MetadataEntity::translatedTextField);

    public MapF<String, String> fields = Cf.hashMap();

    public MetadataEntity() {
    }

    public MetadataEntity(MetadataEntityType entityType) {
        this.fields = Cf.map("type", entityType.type);
    }

    public MetadataEntity(MetadataEntityType entityType, MapF<String, String> fields) {
        this.fields = fields.plus1("type", entityType.type);
    }

    public MetadataEntity(MapF<String, String> fields) {
        this.fields = fields;
    }

    public MetadataEntityType getEntityType() {
        return fields.getO("type").map(MetadataEntityType::new).getOrElse(MetadataEntityType.OTHER);
    }

    public void put(String name, String value) {
        fields = fields.plus1(name, value);
    }

    public MetadataEntity withoutFields(ListF<String> fields) {
        return new MetadataEntity(this.fields.filterKeys(fields.containsF().notF()));
    }

    public String get(String name) {
        return fields.getTs(name);
    }

    public Option<String> getO(String name) {
        return fields.getO(name);
    }

    public boolean isEmpty() {
        return fields.isEmpty();
    }

    public MetadataEntity clone() {
        return new MetadataEntity(Cf.<String, String>map().plus(fields));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MetadataEntity entity = (MetadataEntity) o;

        return fields != null ? fields.equals(entity.fields) : entity.fields == null;
    }

    public static MetadataEntity cons(MapF<String, String> map) {
        MapF<String, String> fields = Cf.<String, String>hashMap().plus(map);
        String type = fields.getO("type").getOrElse(MetadataEntityType.OTHER.type);

        return new MetadataEntity(new MetadataEntityType(type), fields);
    }

    public static boolean isMetadataEntityMap(MapF map) {
        if (!map.containsKeyTs("type")) return false;
        for (Object value : map.values()) {
            if (!(value instanceof String)) return false;
        }
        return true;
    }

    public static String translatedTextField(NotifierLanguage lang) {
        return "text@" + lang.value();
    }
}
