package ru.yandex.chemodan.app.notifier.metadata;

import java.util.Objects;

/**
 * Entity types for metadata records. While entity names are not customized and can be free-form
 * (entities are referenced in Tanker messages by names), entity types define entity processing.
 *
 * @author buberman
 */
public class MetadataEntityType {
    public static final MetadataEntityType USER = new MetadataEntityType("user");
    public static final MetadataEntityType YA_DISK = new MetadataEntityType("ya_disk");
    public static final MetadataEntityType RESOURCE = new MetadataEntityType("resource");
    public static final MetadataEntityType PREVIEW = new MetadataEntityType("preview");
    public static final MetadataEntityType COMMENT = new MetadataEntityType("comment");
    public static final MetadataEntityType TEXT = new MetadataEntityType("text");
    public static final MetadataEntityType ACTION = new MetadataEntityType("action");
    public static final MetadataEntityType DATE = new MetadataEntityType("date");
    public static final MetadataEntityType LINK = new MetadataEntityType("link");
    public static final MetadataEntityType TOTAL_PHOTOS = new MetadataEntityType("total_photos");
    public static final MetadataEntityType OTHER = new MetadataEntityType("other");

    public final String type;

    public MetadataEntityType(String type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        return type.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MetadataEntityType that = (MetadataEntityType) o;
        return Objects.equals(type, that.type);
    }
}
