package ru.yandex.chemodan.app.notifier.metadata;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author buberman
 */
public class MetadataMarshaller extends ToFieldMarshallerSupport implements ToFieldWithCallbackMarshaller {
    @Override
    public void writeJsonToFieldWithCallback(BenderJsonWriter writer, Object fieldValue, PojoMarshallingJsonCallback callback, MarshallerContext context) {
        writeJsonToField(writer, fieldValue, context);
    }

    @Override
    public void writeXmlToFieldWithCallback(XmlWriter writer, Object fieldValue, PojoMarshallingXmlCallback callback, MarshallerContext context) {
        writeXmlToField(writer, fieldValue, context);
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object obj, MarshallerContext context) {
        writeMap(writer, ((MetadataWrapper)obj).meta);
    }

    private <T> void writeMap(BenderJsonWriter writer, MapF<String, T> map) {
        writer.writeObjectStart();
        writeMapContents(writer, map);
        writer.writeObjectEnd();
    }

    private <T> void writeMapContents(BenderJsonWriter writer, MapF<String, T> map) {
        for(Tuple2<String, T> keyValue : map.entries()) {
            writer.writeFieldName(keyValue.get1());
            Object o = keyValue.get2();
            if (o instanceof MapF) {
                writeMap(writer, (MapF)o);
            } else if (o instanceof MetadataEntity) {
                MetadataEntity metadataEntity = (MetadataEntity) o;
                writer.writeObjectStart();
                writeMapContents(writer, metadataEntity.fields);
                writer.writeObjectEnd();
            } else {
                writer.writeString(o.toString());
            }
        }
    }
}
