package ru.yandex.chemodan.app.notifier.metadata;

import lombok.Data;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.test.Assert;

/**
 * @author buberman
 */
public class MetadataMarshallerUnmarshallerTest {
    @Test
    public void testMarshallSimpleMap() {
        MapF<String, MetadataEntity> metaPayload =
                Cf.map("lvl1", new MetadataEntity(MetadataEntityType.COMMENT, Cf.map("lvl2", "value")));
        MetadataWrapper meta = new MetadataWrapper(metaPayload);

        String s = new String(MetadataWrapper.parserSerializer.getSerializer().serializeJson(meta));

        Assert.equals("{\"lvl1\":{\"type\":\"comment\",\"lvl2\":\"value\"}}", s);
    }

    @Test
    public void testMarshallUnmarshallData() {
        MapF<String, MetadataEntity> metaPayload = Cf.map(
                "lvl1-1", new MetadataEntity(MetadataEntityType.ACTION, Cf.map(
                        "lvl2-1-1", "value2-1-1",
                        "lvl2-1-2", "value2-1-2",
                        "lvl2-1-3", "value2-1-3"
                )),
                "lvl1-2", new MetadataEntity(MetadataEntityType.COMMENT, Cf.map(
                        "lvl2-2-1", "value2-2-1",
                        "lvl2-2-2", "value2-2-2",
                        "lvl2-2-3", "value2-2-3"
                )),
                "lvl1-3", new MetadataEntity(MetadataEntityType.RESOURCE, Cf.map(
                        "lvl2-3-1", "value2-3-1",
                        "lvl2-3-2", "value2-3-2",
                        "lvl2-3-3", "value2-3-3"
                ))
        );

        MetadataWrapper originalMeta = new MetadataWrapper(metaPayload);

        String s = new String(MetadataWrapper.parserSerializer.getSerializer().serializeJson(originalMeta));

        MetadataWrapper reparsedMeta = MetadataWrapper.parserSerializer.getParser().parseJson(s);

        Assert.equals(originalMeta, reparsedMeta);
    }

    @Test
    public void testMetadataOptionBending() {
        BenderParserSerializer<Holder> ps = MetadataWrapper.mapper.createParserSerializer(Holder.class);

        Function<String, String> reparse = json ->
                new String(ps.getSerializer().serializeJson(ps.getParser().parseJson(json)));

        String value = "{\"name\":\"missing\"}";
        Assert.equals(value, reparse.apply(value));

        value = "{\"name\":\"empty\",\"meta\":{}}";
        Assert.equals(value, reparse.apply(value));

        value = "{\"name\":\"defined\",\"meta\":{\"name\":{\"key\":\"value\"}}}";
        Assert.equals(value, reparse.apply(value));
    }

    @Data
    @BenderBindAllFields
    public static class Holder {
        private final String name;
        private final Option<MetadataWrapper> meta;
    }
}
