package ru.yandex.chemodan.app.notifier.metadata;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.util.bender.JsonRootLevelUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;

/**
 * @author buberman
 */
public class MetadataUnmarshaller implements JsonRootLevelUnmarshaller {

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        return ParseResult.result(new MetadataWrapper(parseMap(node)));
    }

    public MapF parseMap(BenderJsonNode node) {
        MapF result = Cf.hashMap();
        for (String fieldName : node.getFieldNames()) {
            BenderJsonNode valueNode = node.getField(fieldName).get();
            if (valueNode.isString()) {
                result.put(fieldName, valueNode.getValueAsString());
            } else {
                MapF value = parseMap(valueNode);
                if (MetadataEntity.isMetadataEntityMap(value)) {
                    result.put(fieldName, MetadataEntity.cons(value));
                } else {
                    result.put(fieldName, value);
                }
            }
        }
        return result;
    }
}
