package ru.yandex.chemodan.app.notifier.metadata;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author bursy
 */
public class MetadataWrapperTest {
    @Test
    public void fromJsonStringWithAnApostrophe() {
        String s;
        MetadataWrapper meta;

        s = "{\"entity\":{\"type\":\"text\",\"text\":\"some text and also an apostrophe \\\\'\"}}";
        meta = MetadataWrapper.fromJsonString(s);
        Assert.equals("some text and also an apostrophe \\'", meta.getEntityField("entity", "text").get());

        s = "{\"entity\":{\"type\":\"text\",\"text\":\"some text and also an apostrophe \\'\"}}";
        meta = MetadataWrapper.fromJsonString(s);
        Assert.equals("some text and also an apostrophe '", meta.getEntityField("entity", "text").get());

        s = "{\"entity\":{\"type\":\"text\",\"text\":\"some text and also an apostrophe '\"}}";
        meta = MetadataWrapper.fromJsonString(s);
        Assert.equals("some text and also an apostrophe '", meta.getEntityField("entity", "text").get());
    }
}
